/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.hud.impl;

import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.msdf.Font;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.ui.hud.HudElement;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.gui.GuiUtility;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_5250;
import net.minecraft.class_8646;
import net.minecraft.class_9011;

public class ScoreboardHud
extends HudElement {
    private final Animation animationWidth = new Animation(200L, 100.0f, Easing.QUAD_IN_OUT);
    private final Animation animationScale = new Animation(200L, 0.0f, Easing.QUAD_IN_OUT);

    public ScoreboardHud() {
        super("hud.scoreboard", "icons/hud/scoreboard.png");
    }

    @Override
    public void update(UIContext context) {
        if (ScoreboardHud.mc.field_1687 == null || ScoreboardHud.mc.field_1687.method_8428() == null) {
            this.width = 100.0f;
            this.height = 20.0f;
            return;
        }
        class_269 scoreboard = ScoreboardHud.mc.field_1687.method_8428();
        class_266 objective = scoreboard.method_1189(class_8646.field_45157);
        if (objective == null) {
            this.width = 100.0f;
            this.height = 20.0f;
            return;
        }
        Font font = Fonts.REGULAR.getFont(7.0f);
        Font titleFont = Fonts.MEDIUM.getFont(8.0f);
        Collection entries = scoreboard.method_1184(objective);
        List filteredEntries = entries.stream().filter(entry -> !entry.method_55385()).sorted((a, b) -> Integer.compare(b.comp_2128(), a.comp_2128())).limit(15L).collect(Collectors.toList());
        float maxWidth = titleFont.width(objective.method_1114());
        for (class_9011 entry2 : filteredEntries) {
            String name = entry2.comp_2127();
            class_268 team = scoreboard.method_1164(name);
            class_5250 displayName = class_268.method_1142((class_270)team, (class_2561)class_2561.method_43470((String)name));
            float width = font.width((class_2561)displayName) + 10.0f;
            if (!(width > maxWidth)) continue;
            maxWidth = width;
        }
        this.width = this.animationWidth.update(maxWidth + 16.0f);
        this.height = 7.0f + (float)filteredEntries.size() * 10.0f + 5.0f;
        super.update(context);
    }

    @Override
    public void renderComponent(UIContext context) {
        if (ScoreboardHud.mc.field_1687 == null || ScoreboardHud.mc.field_1687.method_8428() == null) {
            return;
        }
        class_269 scoreboard = ScoreboardHud.mc.field_1687.method_8428();
        class_266 objective = scoreboard.method_1189(class_8646.field_45157);
        if (objective == null) {
            return;
        }
        Font font = Fonts.REGULAR.getFont(7.0f);
        Collection entries = scoreboard.method_1184(objective);
        List filteredEntries = entries.stream().filter(entry -> !entry.method_55385()).sorted((a, b) -> Integer.compare(b.comp_2128(), a.comp_2128())).limit(15L).collect(Collectors.toList());
        context.drawClientRect(this.x, this.y, this.width, this.height, this.animation.getValue(), this.dragAnim.getValue(), 4.0f);
        float offsetY = this.y + 7.0f;
        for (int i = 0; i < filteredEntries.size(); ++i) {
            class_9011 entry2 = (class_9011)filteredEntries.get(i);
            String name = entry2.comp_2127();
            class_268 team = scoreboard.method_1164(name);
            class_5250 displayName = class_268.method_1142((class_270)team, (class_2561)class_2561.method_43470((String)name));
            context.drawText(font, (class_2561)displayName, this.x + 7.0f, offsetY + GuiUtility.getMiddleOfBox(font.height(), 10.0f));
            offsetY += 10.0f;
        }
    }

    @Override
    public boolean show() {
        if (ScoreboardHud.mc.field_1687 == null || ScoreboardHud.mc.field_1687.method_8428() == null) {
            return false;
        }
        class_266 objective = ScoreboardHud.mc.field_1687.method_8428().method_1189(class_8646.field_45157);
        return objective != null;
    }
}

